/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import doggytalents.DoggyRegistries;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentOption;
import doggytalents.common.variant.DogVariant;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class NetworkUtil {
    public static void writeTalentToBuf(FriendlyByteBuf buf, Talent val) {
        buf.writeRegistryIdUnsafe(DoggyTalentsAPI.TALENTS.get(), (Object)val);
    }

    public static Talent readTalentFromBuf(FriendlyByteBuf buf) {
        return (Talent)buf.readRegistryIdUnsafe(DoggyTalentsAPI.TALENTS.get());
    }

    public static void writeAccessoryToBuf(FriendlyByteBuf buf, Accessory val) {
        buf.writeRegistryIdUnsafe(DoggyTalentsAPI.ACCESSORIES.get(), (Object)val);
    }

    public static Accessory readAccessoryFromBuf(FriendlyByteBuf buf) {
        return (Accessory)buf.readRegistryIdUnsafe(DoggyTalentsAPI.ACCESSORIES.get());
    }

    public static void writeTalentOptionToBuf(FriendlyByteBuf buf, TalentOption<?> val) {
        buf.writeRegistryIdUnsafe(DoggyTalentsAPI.TALENT_OPTIONS.get(), val);
    }

    public static TalentOption<?> readTalentOptionFromBuf(FriendlyByteBuf buf) {
        return (TalentOption)buf.readRegistryIdUnsafe(DoggyTalentsAPI.TALENT_OPTIONS.get());
    }

    public static void writeItemToBuf(FriendlyByteBuf buf, ItemStack stack) {
        buf.writeItemStack(stack, true);
    }

    public static ItemStack readItemFromBuf(FriendlyByteBuf buf) {
        return buf.m_130267_();
    }

    public static void writeDogVariantToBuf(FriendlyByteBuf buf, DogVariant val) {
        buf.writeRegistryIdUnsafe(DoggyRegistries.DOG_VARIANT.get(), (Object)val);
    }

    public static DogVariant readDogVariantFromBuf(FriendlyByteBuf buf) {
        return (DogVariant)buf.readRegistryIdUnsafe(DoggyRegistries.DOG_VARIANT.get());
    }
}

